/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Animation;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnimationControl
implements Animation.IListener {
    @Nullable
    private final Animation[] openArray;
    @Nullable
    private final Animation[] closeArray;
    private int openState = 0;
    private boolean lockState = false;
    private boolean prepareToOpen = false;
    private boolean prepareToClose = false;
    @Nullable
    private final Animation lastOpenAnimation;
    @Nullable
    private final Animation lastCloseAnimation;

    public AnimationControl(@Nullable List<Animation> openList, @Nullable List<Animation> closeList) {
        Optional<Animation> d;
        this.openArray = openList != null ? openList.toArray(new Animation[0]) : null;
        this.closeArray = closeList != null ? closeList.toArray(new Animation[0]) : null;
        if (openList != null) {
            d = openList.stream().max(Comparator.comparing(Animation::getDuration));
            this.lastOpenAnimation = d.orElse(null);
        } else {
            this.lastOpenAnimation = null;
        }
        if (closeList != null) {
            d = closeList.stream().max(Comparator.comparing(Animation::getDuration));
            this.lastCloseAnimation = d.orElse(null);
        } else {
            this.lastCloseAnimation = null;
        }
        if (this.lastOpenAnimation != null) {
            this.lastOpenAnimation.listen(this);
        }
        if (this.lastCloseAnimation != null) {
            this.lastCloseAnimation.listen(this);
        }
    }

    @Override
    public void onAnimationEnd(@Nonnull Animation animation, boolean isReverse) {
        if (animation == this.lastOpenAnimation) {
            this.openState = 2;
        } else if (animation == this.lastCloseAnimation) {
            this.openState = 0;
        }
    }

    public void update() {
        if (this.prepareToOpen && this.openState == 0) {
            this.openState = 1;
            if (this.openArray != null) {
                for (Animation a : this.openArray) {
                    a.startFull();
                }
            }
            if (this.openArray == null || this.openArray.length == 0) {
                this.openState = 2;
            }
            this.prepareToOpen = false;
        } else if (this.prepareToClose && this.openState == 2) {
            this.openState = 3;
            if (this.closeArray != null) {
                for (Animation a : this.closeArray) {
                    a.startFull();
                }
            }
            if (this.closeArray == null || this.closeArray.length == 0) {
                this.openState = 0;
            }
            this.prepareToClose = false;
        }
    }

    public final void startOpenAnimation() {
        if (!this.lockState) {
            this.prepareToOpen = true;
            this.prepareToClose = false;
        }
    }

    public final void startCloseAnimation() {
        if (!this.lockState) {
            this.prepareToClose = true;
            this.prepareToOpen = false;
        }
    }

    public final boolean isAnimationOpen() {
        return this.openState != 0;
    }

    public final void setLockState(boolean lock) {
        this.lockState = lock;
    }

    public final boolean isUnlockState() {
        return !this.lockState;
    }
}

